//
//  HNSShapeView.h
//  HNSAppKit
//
//  Created by Dr. H. Nikolaus Schaller on Thu Apr 03 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

typedef enum HNSShapeType
{
	HNSLineShape=0,
	HNSBoxShape,
	HNSRectangleShape,
	HNSEllipsoidShape,
	HNSBezierShape
} HNSShapeType;

typedef enum HNSShapeArrowType
{
	HNSShapeNoArrow=0,
	HNSShapeEndArrow,
	HNSShapeBeginArrow,
	HNSShapeBothArrows
} HNSShapeArrowType;

@interface HNSShapeView : NSControl {
	// wrapper for single cell
	HNSShapeType type;		// shape type
	HNSShapeArrowType arrow;
	NSBezierPath *path;	// for bezier shape
	NSImage *image;
	NSColor *backgroundColor;
	NSColor *strokeColor;
	NSColor *fillColor;
	NSColor *boxColor;
}

@end

@interface HNSShapeCell : NSActionCell {
	HNSShapeType type;		// shape type
	HNSShapeArrowType arrow;
	NSBezierPath *path;	// for bezier shape
	NSImage *image;
	NSColor *backgroundColor;
	NSColor *strokeColor;
	NSColor *fillColor;
	NSColor *boxColor;	
}

- (void) setType:(HNSShapeType) type;

// set color, pattern, rotation, ...

@end
